% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoGO-package.R, R/autoGO.R
\docType{package}
\name{autoGO}
\alias{autoGO}
\alias{_PACKAGE}
\alias{autoGO-package}
\title{autoGO: Auto-GO: Reproducible, Robust and High Quality Ontology Enrichment Visualizations}
\usage{
autoGO(
  list_of_genes,
  dbs = c("GO_Molecular_Function_2021", "GO_Biological_Process_2021", "KEGG_2021_Human"),
  my_comparison = NULL,
  ensembl = FALSE,
  excel = FALSE,
  outfolder = NULL
)
}
\arguments{
\item{list_of_genes}{it can be a list of dataframes containing gene names (i.e. from the output of read_gene_lists()), a single dataframe or character vector of gene names, or a path to a .txt file containing one gene name per row.}

\item{dbs}{Databases over which the enrichment will be performed, based on the enrichR libraries. Default are GO_Molecular_Function_2021, GO_Cellular_Component_2021, GO_Biological_Process_2021, KEGG_2021_Human. Run choose_database() to see all the possible databases.}

\item{my_comparison}{Name of the comparison (or the analysis) the user would like to inspect. Ignored if list_of_genes is a list. taken from the path.}

\item{ensembl}{(Default = FALSE). Set to TRUE if the provided gene list contains Ensembl IDs. A conversion to HGNC will be performed.}

\item{excel}{(Default = FALSE). Set to TRUE if you want to save output tables in .xlsx format.}

\item{outfolder}{Default to NULL. The name to assign to the folder in which outputs are saved. Ignored if list_of_genes is a list, taken from the path.}
}
\value{
No return value. Files will be produced as part of normal execution.
}
\description{
Auto-GO is a framework that enables automated, high quality Gene Ontology enrichment analysis visualizations. It also features a handy wrapper for Differential Expression analysis around the 'DESeq2' package described in Love et al. (2014) \doi{10.1186/s13059-014-0550-8}. The whole framework is structured in different, independent functions, in order to let the user decide which steps of the analysis to perform and which plot to produce.

Perform enrichment analysis on all the desired gene lists. This function take advantage of the 'enrichR' package.
}
\examples{
\dontrun{
autoGO(
  list_of_genes = gene_lists,
  dbs = c("GO_Molecular_Function_2021", "GO_Biological_Process_2021", "KEGG_2021_Human"),
  my_comparison = NULL,
  ensembl = F,
  excel = F,
  outfolder = NULL
)
}
}
\author{
\strong{Maintainer}: Fabio Ticconi \email{fabio.ticconi@gmail.com} (\href{https://orcid.org/0000-0001-8905-6657}{ORCID})

Authors:
\itemize{
  \item Isabella Grassucci \email{isabella.grassucci@gmail.com} (\href{https://orcid.org/0000-0002-2484-8570}{ORCID})
  \item Eleonora Sperandio \email{eleonora.sperandio@ifo.it} (\href{https://orcid.org/0000-0002-8572-6788}{ORCID})
  \item Alice Massacci \email{alice.massacci@ifo.it} (\href{https://orcid.org/0000-0001-7780-809X}{ORCID})
  \item Lorenzo D'Ambrosio \email{lorenzo.dambrosio@ifo.it} (\href{https://orcid.org/0000-0002-9656-7436}{ORCID})
  \item Matteo Pallocca \email{matteo.pallocca@ifo.it} (\href{https://orcid.org/0000-0002-7756-3579}{ORCID})
}

}
\keyword{internal}
