% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc_AMFA.R
\name{AMFA.inc}
\alias{AMFA.inc}
\title{Incremental Automated Mixtures of Factor Analyzers}
\usage{
AMFA.inc(
  Y,
  numTries = 2,
  eta = 0.005,
  itmax = 500,
  tol = 1e-05,
  conv_measure = "diff",
  nkmeans = 1,
  nrandom = 1,
  varimax = FALSE
)
}
\arguments{
\item{Y}{An \emph{n} by \emph{p} data matrix, where \emph{n} is the number of observations and \emph{p} is the number of dimensions of the data.}

\item{numTries}{The number of attempts that should be made to split each component.}

\item{eta}{The smallest possible entry in any of the error matrices \emph{D_i} \insertCite{Jian-HuaZhao2008FMEf}{autoMFA}.}

\item{itmax}{The maximum number of ECM iterations allowed for the estimation of each MFA model.}

\item{tol}{The ECM algorithm terminates if the measure of convergence falls below this value.}

\item{conv_measure}{The convergence criterion of the ECM algorithm. The default \code{'diff'} stops the ECM iterations if |l^{(k+1)} - l^{(k)}| < \code{tol} where l^{(k)} is the log-likelihood at the \emph{k}th ECM iteration. If \code{'ratio'}, then the convergence of the ECM iterations is measured using |(l^{(k+1)} - l^{(k)})/l^{(k+1)}|.}

\item{nkmeans}{The number of times the \emph{k}-means algorithm will be used to initialise the (single component) starting models.}

\item{nrandom}{The number of randomly initialised (single component) starting models.}

\item{varimax}{Boolean indicating whether the output factor loading matrices should be constrained
using varimax rotation or not.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{model}:}{ A list specifying the final MFA model. This contains: \itemize{
\item{\code{B}:}{ A \emph{p} by \emph{p} by \emph{q} array containing the factor loading matrices for each component.}
\item{\code{D}:}{ A \emph{p} by \emph{p} by \emph{g} array of error variance matrices.}
\item{\code{mu}:}{  A \emph{p} by \emph{g} array containing the mean of each cluster.}
\item{\code{pivec}:}{ A 1 by \emph{g} vector containing the mixing
proportions for each FA in the mixture.}
\item{\code{numFactors}:}{ A 1 by \emph{g} vector containing the number of factors for each FA.}}
}
\item{\code{clustering}:}{ A list specifying the clustering produced by the final model. This contains: \itemize{
\item{\code{responsibilities}:}{ A \emph{n} by \emph{g} matrix containing the probability
that each point belongs to each FA in the mixture.}
\item{\code{allocations}:}{ A \emph{n} by 1 matrix containing which
FA in the mixture each point is assigned to based on the responsibilities.}}}
\item{\code{diagnostics}:}{ A list containing various pieces of information related to the fitting process of the algorithm. This contains: \itemize{
\item{\code{bic}:}{ The BIC of the final model.}
\item{\code{logL}:}{ The log-likelihood of the final model.}
\item{\code{totalTime}:}{ The total time taken to fit the final model.}}}
}
}
\description{
An alternative implementation of AMFA algorithm \insertCite{WangWan-Lun2020Alom}{autoMFA}. The number of factors, \emph{q}, is estimated during the fitting process of each MFA model.
Instead of employing a grid search over \emph{g} like the \code{AMFA} method, this method starts with a \emph{1} component MFA model and splits components according to their multivariate kurtosis. This uses the same approach as \code{amofa} \insertCite{kaya2015adaptive}{autoMFA}.
Once a component has been selected for splitting, the new components are initialised in the same manner as \code{vbmfa} \insertCite{ghahramani2000variational}{autoMFA}.
It keeps trying to split components until all components have had \code{numTries} splits attempted with no decrease in BIC, after which the current model is returned.
}
\examples{
RNGversion('4.0.3'); set.seed(3) 
MFA.fit <- AMFA.inc(autoMFA::MFA_testdata, itmax = 1, numTries = 0)
}
\references{
\insertRef{WangWan-Lun2020Alom}{autoMFA}

\insertRef{kaya2015adaptive}{autoMFA}

\insertRef{ghahramani2000variational}{autoMFA}

\insertRef{Jian-HuaZhao2008FMEf}{autoMFA}
}
\seealso{
\code{\link{amofa}} \code{\link{vbmfa}}
}
