% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcmdif.R
\name{pcm_dif}
\alias{pcm_dif}
\alias{fitStats.pcmdif}
\alias{summary.pcmdif}
\alias{print.pcmdif}
\title{Estimation of The Partial Credit Model with DIF}
\usage{
pcm_dif(
  X,
  init_par = c(),
  groups_map = c(),
  setting = c(),
  method = c("fast", "novel")
)

\method{fitStats}{pcmdif}(obj, isAlpha = TRUE)

\method{summary}{pcmdif}(object, ...)

\method{print}{pcmdif}(x, ...)
}
\arguments{
\item{X}{A matrix or data frame as an input with ordinal responses (starting from 0);
rows represent individuals, columns represent items.}

\item{init_par}{a vector of initial values of the estimated parameters.}

\item{groups_map}{Binary matrix. Respondents membership to DIF groups; rows represent individuals, column represent group partitions.}

\item{setting}{a list of the optimization control setting parameters.See \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}}}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{obj}{The object of class \code{'pcmdif'}.}

\item{isAlpha}{Boolean value that indicates whether the discrimination parameters is needed to be estimated or not.
The discrimination parameters are estimated using the corresponding models (GPCM or GPCM-DIF).}

\item{object}{The object of class \code{'pcmdif'}.}

\item{...}{Further arguments to be passed.}

\item{x}{The object of class \code{'pcmdif'}.}
}
\value{
\strong{\code{pcm_dif()} will return a \code{\link[base:list]{list}} which contains:}
\item{X}{   The dataset that is used for estimation.}
\item{mt_vek}{   A vector of the highest response given to items.}
\item{itemName}{   The vector of names of items (columns) in the dataset.}
\item{loglik}{   The log likelihood of the estimation.}
\item{hessian}{   The hessian matrix. Only when the \code{isHessian = TRUE}.}
\item{beta}{   A vector of the difficulty parameter of each categories of items (thresholds).}
\item{theta}{   A vector of the ability parameters of each individuals.}

\strong{\code{fitStats()} will return a \code{\link[base:list]{list}} which contains:}
\item{alpha}{   A vector of estimated discrimination parameters for each items.}
\emph{i.fit}{   Item fit statistics.}
\itemize{
\item{i.outfitMSQ}{   A vector of Outfit mean square values for each items.}
\item{i.infitMSQ}{   A vector of Infit mean square values for each items.}
\item{i.outfitZ}{   A vector of OutfitZ values for each items.}
\item{i.infitZ}{   A vector of InfitZ values for each items.}
}
\emph{p.fit}{   Person fit statistics.}
\itemize{
\item{p.outfitMSQ}{   A vector of Outfit mean square values for each persons.}
\item{p.infitMSQ}{   A vector of Infit mean square values for each persons.}
\item{p.outfitZ}{   A vector of OutfitZ values for each persons.}
\item{p.infitZ}{   A vector of InfitZ values for each persons.}
}
\emph{traceMat}{   Some computed matrices in the process.}
\itemize{
\item{emat}{   The expected values matrix.}
\item{vmat}{   The variance matrix.}
\item{cmat}{   The curtosis matrix.}
\item{std.res}{   The standardized residual.}
}
}
\description{
This function computes the parameter estimates of a partial credit model with DIF for dichotomous and polytomous responses
by implementing the coordinate descent.

\code{fitStats} compute the fit statistics (i.e., Outfit and Infit) of the PCM-DIF model estimation (items and persons).
}
\examples{
\dontrun{
pcmdif_res <- pcm_dif(shortDIF, groups_map = c(rep(1,50),rep(0,50)))
fit_res <- fitStats(pcmdif_res)
itemfit(fit_res)
personfit(fit_res)
plot_fitStats(fit_res, toPlot = c("alpha","outfit"), useName = FALSE)
}

}
\seealso{
\code{\link{pcm}}, \code{\link{pcm_dif}}, \code{\link{gpcm}}, \code{\link{gpcm_dif}}
}
