% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcmprsk.R
\name{ggcmprsk}
\alias{ggcmprsk}
\title{Draw Cumulative Incidence Curves for Competing Risks}
\usage{
ggcmprsk(x, data, id = NULL, se = FALSE)
}
\arguments{
\item{x}{A formula as time+status~1}

\item{data}{A data.frame}

\item{id}{character vector}

\item{se}{logical whether or not show confidence interval}
}
\value{
An object of class "ggplot"
}
\description{
Draw Cumulative Incidence Curves for Competing Risks
}
\examples{
data(melanoma,package="boot")
melanoma$status1 = ifelse(melanoma$status==1,1,ifelse(melanoma$status==2,0,2))
ggcmprsk(time/365+status1~1,data=melanoma,id=c("melanoma","other"))
}
