% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReg.survreg.R
\name{autoRegsurvreg}
\alias{autoRegsurvreg}
\title{perform automatic regression for a class of survreg}
\usage{
autoRegsurvreg(
  x,
  threshold = 0.2,
  uni = FALSE,
  multi = TRUE,
  final = FALSE,
  imputed = FALSE,
  keepstats = FALSE,
  mode = 1,
  ...
)
}
\arguments{
\item{x}{An object of class survreg}

\item{threshold}{numeric}

\item{uni}{logical whether or not perform univariable regression}

\item{multi}{logical whether or not perform multivariable regression}

\item{final}{logical whether or not perform stepwise backward elimination}

\item{imputed}{logical whether or not perform multiple imputation}

\item{keepstats}{logical whether or not keep statistic}

\item{mode}{integer}

\item{...}{Further arguments to be passed to gaze()}
}
\value{
autoRegsurvreg returns an object of class "autoReg" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
\item{attr(*,"model")}{name of model. One of "lm","glm","coxph" or "survreg"}
}
}
\description{
perform automatic regression for a class of survreg
}
\examples{
require(survival)
require(dplyr)
data(cancer)
fit=survreg(Surv(time,status)~rx+age+sex+nodes+obstruct+perfor,data=colon)
autoReg(fit)
autoReg(fit,uni=TRUE,threshold=1)
autoReg(fit,uni=TRUE,final=TRUE)
autoReg(fit,uni=TRUE,final=TRUE) \%>\% myft()
\dontrun{
autoReg(fit,mode=2)
autoReg(fit,uni=TRUE,threshold=1,,mode=2)
autoReg(fit,uni=TRUE,final=TRUE,mode=2)
autoReg(fit,uni=TRUE,final=TRUE,mode=2) \%>\% myft()
autoReg(fit,final=TRUE,imputed=TRUE) \%>\% myft()
autoReg(fit,final=TRUE,imputed=TRUE,mode=2) \%>\% myft()
}
}
