% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoforest.R
\name{predictAutoforest}
\alias{predictAutoforest}
\title{Make a prediction using an autoforest model returned from the \code{autoforest} function.}
\usage{
predictAutoforest(
  autoforestModel,
  newdata,
  newdataCoords = NULL,
  useSpatialNodes = FALSE,
  method = "idw",
  distpower = 2,
  distpowerRange = c(0, 2),
  modelByResidual = TRUE,
  decideByGC = FALSE
)
}
\arguments{
\item{autoforestModel}{An S3 object of type "autoforest" returned from the \code{autoforest} function.}

\item{newdata}{The dataframe of predictors for use in prediction.}

\item{newdataCoords}{the matrix of locations for all the information in newdata. Required argument if you set "useSpatialNodes" to TRUE.}

\item{useSpatialNodes}{If TRUE, instead of running all the observations through the autocart tree, use the \code{spatialNodes} function to make predictions.}

\item{method}{If using the spatial nodes type of prediction, then the type of interpolation to use. The options are "idw" and "tps".}

\item{distpower}{If using "idw" for the method, the power on distance. For example, setting this to 2 would mean inverse squared distance squared weighting.}

\item{distpowerRange}{If using "idw" for the interpolation method, the range of distance powers to use on inverse distance weighting matched to terminal node Moran I measurements.}

\item{modelByResidual}{When using interpolation, make a prediction using the region of interest's average and then interpolate the residual.}

\item{decideByGC}{Use Geary's C in deciding to induce a local spatial process rather than Moran's I.}
}
\value{
A vector of predictions that correspond to the rows in \code{newdata}.
}
\description{
Make a prediction using an autoforest model returned from the \code{autoforest} function.
}
\examples{
# Load some data for an autoforest example
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:40]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]

# Create a control object for the autoforest tree
snow_control <- autocartControl(spatialBandwidthProportion = 1.0)

# Create an autoforest model with 5 trees (low number chosen for computation time)
snow_model <- autoforest(y, X, locations, 0.30, 0, snow_control, numtrees = 5)

# Predict for a subset of the data
new_X <- X[1:10, ]
new_loc <- locations[1:10, ]
predicted_values <- predictAutoforest(snow_model, new_X, new_loc, TRUE)
}
