% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_routines.R
\name{keep_branches}
\alias{keep_branches}
\title{Keep only branches specified by node numbers}
\usage{
keep_branches(th, branch_nodes, include_lower = TRUE)
}
\arguments{
\item{th}{A TreeHarp object.}

\item{branch_nodes}{An integer vector, specifying the nodes to keep.}

\item{include_lower}{A logical value - whether or not the lower branches should 
also be kept.}
}
\value{
A TreeHarp object.
}
\description{
Retains only specific branches, that are identified by their node numbers.
}
\examples{
ex1 <- quote(x <- f(y, g(5)))
th1 <- TreeHarp(ex1, TRUE)
keep_branches(th1, 3)
keep_branches(th1, 3, include_lower = FALSE)
keep_branches(th1, c(2,3), FALSE)
keep_branches(th1, c(3, 4), FALSE)
}
