% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdsurvma.R
\name{hdsurvma}
\alias{hdsurvma}
\title{High dimensional survival analysis using SurvMCmulti with mediation analysis}
\usage{
hdsurvma(m, n, Surv, Event, ths, chn, i, adp, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{Surv}{"Column/Variable name" consisting duration of survival.}

\item{Event}{"Column/Variable name" consisting survival event.}

\item{ths}{A numeric between 0 to 100.}

\item{chn}{Number of MCMC chains to perform survival analysis.}

\item{i}{Number of MCMC iterations to perform survival analysis.}

\item{adp}{Number of MCMC adaptations to perform survival analysis.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws.}

\item{data}{High dimensional data containing survival observations and high dimensional covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function filters significant variables,
allowing the user to perform survival analysis with high number of iterations. Further, it performs mediation analysis among the signifiant
variables and provides handful variables with their alpha.a values which are mediator model exposure coefficients
and beta.a coefficients.
}
\examples{
\dontrun{
data2 <- hnscc2[1:50,]
hdsurvma(m=8,n=15,Surv="os",Event="death",ths=0.02,chn=4,i=10,adp=100,b=10,d=10,data=data2)
}
}
