% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_model_accuracy.R
\name{auto_model_accuracy}
\alias{auto_model_accuracy}
\title{auto model accuracy}
\usage{
auto_model_accuracy(
  data,
  formula,
  n_folds = 4,
  as_flextable = TRUE,
  theme = "tron",
  seed = 1,
  mtry = 1,
  trees = 15L,
  min_n = 1L,
  tree_depth = 6L,
  learn_rate = 0.3,
  loss_reduction = 0,
  sample_size = 1,
  stop_iter = Inf,
  counts = FALSE,
  penalty = 0.015,
  mixture = 0.35
)
}
\arguments{
\item{data}{data frame}

\item{formula}{formula}

\item{n_folds}{number of cross validation folds}

\item{as_flextable}{if FALSE, returns a tibble}

\item{theme}{make_flextable theme}

\item{seed}{seed}

\item{mtry}{# Randomly Selected Predictors (xgboost: colsample_bynode) (type: numeric, range 0 - 1) (or type: integer if \code{count = TRUE})}

\item{trees}{# Trees (xgboost: nrounds) (type: integer, default: 15L)}

\item{min_n}{Minimal Node Size (xgboost: min_child_weight) (type: integer, default: 1L); Keep small value for highly imbalanced class data where leaf nodes can have smaller size groups.}

\item{tree_depth}{Tree Depth (xgboost: max_depth) (type: integer, default: 6L); Typical values: 3-10}

\item{learn_rate}{Learning Rate (xgboost: eta) (type: double, default: 0.3); Typical values: 0.01-0.3}

\item{loss_reduction}{Minimum Loss Reduction (xgboost: gamma) (type: double, default: 0.0);  range: 0 to Inf; typical value: 0 - 1 assuming low-mid tree depth}

\item{sample_size}{Proportion Observations Sampled (xgboost: subsample) (type: double, default: 1.0); Typical values: 0.5 - 1}

\item{stop_iter}{# Iterations Before Stopping (xgboost: early_stop) (type: integer, default: Inf)}

\item{counts}{if \code{TRUE} specify \code{mtry} as an integer number of cols. Default \code{FALSE} to specify \code{mtry} as fraction of cols from 0 to 1}

\item{penalty}{linear regularization parameter}

\item{mixture}{linear model parameter, combines l1 and l2 regularization}
}
\value{
a table
}
\description{
Runs a cross validated xgboost and regularized linear regression, and reports accuracy metrics.
Automatically determines whether the provided formula is a regression or classification.
}
