% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/select_valid_masks.r
\name{select_valid_masks}
\alias{select_valid_masks}
\title{Select and return valid dummy outlier masks}
\usage{
select_valid_masks(all_outlier_masks, invalid_mask)
}
\arguments{
\item{all_outlier_masks}{A vector of possible outlier masks (integers).}

\item{invalid_mask}{An integer encoding the invalid columns.}
}
\value{
The valid outlier_masks as a vector of integers.
}
\description{
Valid dummy outlier masks are integers whose bitwise AND with the given \code{invalid_mask} is zero. This function returns the subset of integers of the given vector that does not share any bits with the given \code{invalid_mask}.
}
\examples{
all_outlier_masks <- c(0, 1, 2, 3, 4, 5, 6, 7)
invalid_mask <- 1
autovarCore:::select_valid_masks(all_outlier_masks, invalid_mask)
}

