% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_keras_wrapper.R
\name{KERAS_WRAPPER$image_to_array}
\alias{KERAS_WRAPPER$image_to_array}
\title{Load an image as numpy array}
\arguments{
\item{path}{Character. Path to the image.}

\item{height}{Integer. Target height of the image.}

\item{width}{Integer. Target width of the image.}
}
\value{
A numpy array.
}
\description{
This function loads an image from file and convert it to a
numpy array.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{KERAS_WRAPPER$image_to_array(
  path,
  height = self$get_input_height(),
  width = self$get_input_width()
)
}\if{html}{\out{</div>}}
}
}
\examples{
p <- ggplot2::ggplot(cars) + ggplot2::geom_point(ggplot2::aes(dist, speed))
path <- save_plot(p)
result <- try(KERAS_WRAPPER$image_to_array(path, 32L, 32L))
if (!inherits(result, "try-error")) {
  result
}

}
