#' aves_peru_2025_v1
#'
#' The `aves_peru_2025_v1` dataset provides an updated tibble of bird
#' species recorded in Peru, based on the latest taxonomic revisions
#' by the South American Checklist Committee (SACC).
#'
#' This version incorporates significant taxonomic changes, new categories,
#' and updates derived from recent publications, photographs, and sound
#' recordings archived in accredited institutions. Additionally, a classification
#' criterion has been included, following the SACC guidelines.
#'
#' @format A tibble with 1,911 rows and 6 columns:
#'   \describe{
#'     \item{order_name}{Taxonomic order to which the bird species belongs.}
#'     \item{family_name}{Taxonomic family to which the bird species belongs.}
#'     \item{scientific_name}{Scientific name of the bird species.}
#'     \item{english_name}{English common name of the bird species.}
#'     \item{spanish_name}{Spanish common name of the bird species.}
#'     \item{status}{Category indicating the species' status, based on
#'      the following codes:
#'      X - Resident species.
#'      E - Endemic species: A species is considered endemic to Peru until a record outside its borders is published.
#'      NB - Non-breeding species: Species that occur regularly in Peru but only during their non-breeding period.
#'      V - Vagrant species: Erratic species that occasionally occur in Peru and are not part of the usual avifauna.
#'      IN - Introduced species: Species introduced to Peru by humans (or have colonized from introduced populations elsewhere) and have established self-sustaining breeding populations.
#'      H - Hypothetical species: Records based only on observations, specimens of dubious origin, unpublished photographs, or recordings kept in private hands.
#'      EX - Extinct or extirpated species: Species that have gone extinct or have been extirpated from Peru.
#'       }
#'     }
#'
#'
#' @details
#' - **Total species**: 1,911
#' - **Distribution by status**:
#'   \itemize{
#'     \item{\code{X}}: 1,542 species
#'     \item{\code{E}}: 118 species
#'     \item{\code{NB}}: 138 species
#'     \item{\code{V}}: 84 species
#'     \item{\code{IN}}: 3 species
#'     \item{\code{EX}}: 0 species
#'     \item{\code{H}}: 26 species
#'   }
#'
#' These updates reflect the SACC's ongoing efforts to evaluate and recognize certain subspecies as full species.
#'
#' @examples
#' # Load the dataset
#' data("aves_peru_2025_v1")
#'
#' # Display the first few rows
#' head(aves_peru_2025_v1)
#'
#' @seealso
#' For more information about the taxonomy, visit the South American Checklist Committee (SACC) website:
#' \url{https://sites.google.com/site/boletinunop/checklist}
#'
#' @references
#' Plenge, M. A. (2025). Lista de las aves del Perú. Last updated: February 6, 2025.
#' Unión de Ornitólogos del Perú.
#'
#' @author
#' Data compilation: Manuel A. Plenge
#' Package implementation: Paul Efren Santos Andrade
#'
#' @keywords dataset birds Peru taxonomy SACC ornithology
"aves_peru_2025_v1"
