% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocate Address}
\usage{
ec2_allocate_address(
  Domain = NULL,
  Address = NULL,
  PublicIpv4Pool = NULL,
  NetworkBorderGroup = NULL,
  CustomerOwnedIpv4Pool = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Domain}{String.   Indicates whether the Elastic IP address is for use with instances in a VPC or instances in EC2-Classic....[optional]}

\item{Address}{String. [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an address pool.[optional]}

\item{PublicIpv4Pool}{String. The ID of an address pool that you own.[optional]}

\item{NetworkBorderGroup}{String.   A unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises...[optional]}

\item{CustomerOwnedIpv4Pool}{String. The ID of a customer-owned address pool.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to assign to the Elastic IP address.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Allocate Address
}
\section{Domain}{


Indicates whether the Elastic IP address is for use with instances in a
VPC or instances in EC2-Classic.

Default: If the Region supports EC2-Classic, the default is \code{standard}.
Otherwise, the default is \code{vpc}.
}

\section{Address}{

[EC2-VPC] The Elastic IP address to recover or an
IPv4 address from an address pool.
}

\section{PublicIpv4Pool}{

The ID of an
address pool that you own. Use this parameter to let Amazon EC2 select
an address from the address pool. To specify a specific address from the
address pool, use the \code{Address} parameter instead.
}

\section{NetworkBorderGroup}{


A unique set of Availability Zones, Local Zones, or Wavelength Zones
from which AWS advertises IP addresses. Use this parameter to limit the
IP address to this location. IP addresses cannot move between network
border groups.

Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html}{DescribeAvailabilityZones}
to view the network border groups.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.
}

\section{CustomerOwnedIpv4Pool}{

The ID of a customer-owned address pool. Use this
parameter to let Amazon EC2 select an address from the address pool.
Alternatively, specify a specific address from the address
pool.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to assign to the
Elastic IP address.
}

