% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_authorize_security_group_egress}
\alias{ec2_authorize_security_group_egress}
\title{Authorize Security Group Egress}
\usage{
ec2_authorize_security_group_egress(
  GroupId,
  DryRun = NULL,
  IpPermissions = NULL,
  CidrIp = NULL,
  FromPort = NULL,
  IpProtocol = NULL,
  ToPort = NULL,
  SourceSecurityGroupName = NULL,
  SourceSecurityGroupOwnerId = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupId}{String. The ID of the security group.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{IpPermissions}{List. The sets of IP permissions.[optional]}

\item{CidrIp}{String. Not supported. Use a set of IP permissions to specify the CIDR.[optional]}

\item{FromPort}{Integer. Not supported. Use a set of IP permissions to specify the port.[optional]}

\item{IpProtocol}{String. Not supported. Use a set of IP permissions to specify the protocol name or number.[optional]}

\item{ToPort}{Integer. Not supported. Use a set of IP permissions to specify the port.[optional]}

\item{SourceSecurityGroupName}{String. Not supported. Use a set of IP permissions to specify a destination security group.[optional]}

\item{SourceSecurityGroupOwnerId}{String. Not supported. Use a set of IP permissions to specify a destination security group.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Authorize Security Group Egress
}
\section{GroupId}{

The ID of
the security group.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{IpPermissions}{

The sets of IP permissions.
You can\'t specify a destination security group and a CIDR IP address
range in the same set of permissions.
}

\section{CidrIp}{

Not supported.
Use a set of IP permissions to specify the CIDR.
}

\section{FromPort}{

Not
supported. Use a set of IP permissions to specify the
port.
}

\section{IpProtocol}{

Not supported. Use a set of IP permissions to
specify the protocol name or number.
}

\section{ToPort}{

Not supported.
Use a set of IP permissions to specify the port.
}

\section{SourceSecurityGroupName}{

Not
supported. Use a set of IP permissions to specify a destination security
group.
}

\section{SourceSecurityGroupOwnerId}{

Not supported. Use a set of IP permissions to
specify a destination security group.
}

