% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_customer_gateway}
\alias{ec2_create_customer_gateway}
\title{Create Customer Gateway}
\usage{
ec2_create_customer_gateway(
  BgpAsn,
  Type,
  IpAddress = NULL,
  CertificateArn = NULL,
  TagSpecification = NULL,
  DeviceName = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{BgpAsn}{Integer.   For devices that support BGP, the customer gateway\'s BGP ASN.  Default: 65000}

\item{Type}{String. The type of VPN connection that this customer gateway supports (\code{ipsec.1}).}

\item{IpAddress}{String. The Internet-routable IP address for the customer gateway\'s outside interface.[optional]}

\item{CertificateArn}{String. The Amazon Resource Name (ARN) for the customer gateway certificate.[optional]}

\item{TagSpecification}{List. The tags to apply to the customer gateway.[optional]}

\item{DeviceName}{String.   A name for the customer gateway device.  Length Constraints: Up to 255 characters.  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Customer Gateway
}
\section{BgpAsn}{


For devices that support BGP, the customer gateway\'s BGP ASN.

Default: 65000
}

\section{Type}{

The type of VPN connection that this customer
gateway supports (\code{ipsec.1}).
}

\section{IpAddress}{

The Internet-routable
IP address for the customer gateway\'s outside interface. The address
must be static.
}

\section{CertificateArn}{

The Amazon Resource Name (ARN) for
the customer gateway certificate.
}

\section{TagSpecification}{

The tags to apply
to the customer gateway.
}

\section{DeviceName}{


A name for the customer gateway device.

Length Constraints: Up to 255 characters.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

