% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_tags}
\alias{ec2_describe_tags}
\title{Describe Tags}
\usage{
ec2_describe_tags(
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return in a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Tags
}
\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{Filter}{


The filters.
\itemize{
\item \code{key} - The tag key.
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The resource type (\code{customer-gateway} \|
\code{dedicated-host} \| \code{dhcp-options} \| \code{elastic-ip} \| \code{fleet} \|
\code{fpga-image} \| \code{host-reservation} \| \code{image} \| \code{instance} \|
\code{internet-gateway} \| \code{key-pair} \| \code{launch-template} \|
\code{natgateway} \| \code{network-acl} \| \code{network-interface} \|
\code{placement-group} \| \code{reserved-instances} \| \code{route-table} \|
\code{security-group} \| \code{snapshot} \| \code{spot-instances-request} \|
\code{subnet} \| \code{volume} \| \code{vpc} \| \code{vpc-endpoint} \|
\code{vpc-endpoint-service} \| \code{vpc-peering-connection} \|
\code{vpn-connection} \| \code{vpn-gateway}).
\item \code{tag}:\ - The key/value combination of the tag. For example,
specify \'tag:Owner\' for the filter name and \'TeamA\' for the
filter value to find resources with the tag \'Owner=TeamA\'.
\item \code{value} - The tag value.
}
}

\section{MaxResults}{

The maximum number of results to return in a single
call. This value can be between 5 and 1000. To retrieve the remaining
results, make another call with the returned \code{NextToken}
value.
}

