% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_transit_gateway_peering_attachments}
\alias{ec2_describe_transit_gateway_peering_attachments}
\title{Describe Transit Gateway Peering Attachments}
\usage{
ec2_describe_transit_gateway_peering_attachments(
  TransitGatewayAttachmentIds = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayAttachmentIds}{List. One or more IDs of the transit gateway peering attachments.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes your transit gateway
peering attachments.
}
\section{TransitGatewayAttachmentIds}{

One or more IDs of the
transit gateway peering attachments.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{transit-gateway-attachment-id} - The ID of the transit gateway
attachment.
\item \code{local-owner-id} - The ID of your AWS account.
\item \code{remote-owner-id} - The ID of the AWS account in the remote Region
that owns the transit gateway.
\item \code{state} - The state of the peering attachment. Valid values are
\code{available} \| \code{deleted} \| \code{deleting} \| \code{failed} \| \code{failing} \|
\code{initiatingRequest} \| \code{modifying} \| \code{pendingAcceptance} \|
\code{pending} \| \code{rollingBack} \| \code{rejected} \| \code{rejecting}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources that have a tag with a specific key,
regardless of the tag value.
\item \code{transit-gateway-id} - The ID of the transit gateway.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

