% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_endpoint_connections}
\alias{ec2_describe_vpc_endpoint_connections}
\title{Describe Vpc Endpoint Connections}
\usage{
ec2_describe_vpc_endpoint_connections(
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes
the VPC endpoint connections to your VPC endpoint services, including
any endpoints that are pending your
acceptance.
}
\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{service-id} - The ID of the service.
\item \code{vpc-endpoint-owner} - The AWS account number of the owner of the
endpoint.
\item \code{vpc-endpoint-state} - The state of the endpoint
(\code{pendingAcceptance} \| \code{pending} \| \code{available} \| \code{deleting} \|
\code{deleted} \| \code{rejected} \| \code{failed}).
\item \code{vpc-endpoint-id} - The ID of the endpoint.
}
}

\section{MaxResults}{

The maximum number of results to return for the
request in a single page. The remaining results of the initial request
can be seen by sending another request with the returned \code{NextToken}
value. This value can be between 5 and 1,000; if \code{MaxResults} is given a
value larger than 1,000, only 1,000 results are
returned.
}

