% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_associated_enclave_certificate_iam_roles}
\alias{ec2_get_associated_enclave_certificate_iam_roles}
\title{Get Associated Enclave Certificate Iam Roles}
\usage{
ec2_get_associated_enclave_certificate_iam_roles(
  CertificateArn = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CertificateArn}{String. The ARN of the ACM certificate for which to view the associated IAM roles, encryption keys, and Amazon...[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Returns the IAM roles that are associated with the
specified AWS Certificate Manager (ACM) certificate. It also returns the
name of the Amazon S3 bucket and the Amazon S3 object key where the
certificate, certificate chain, and encrypted private key bundle are
stored, and the ARN of the AWS Key Management Service (KMS) customer
master key (CMK) that\'s used to encrypt the private
key.
}
\section{CertificateArn}{

The ARN of the ACM
certificate for which to view the associated IAM roles, encryption keys,
and Amazon S3 object information.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

