% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_put_attributes}
\alias{ecs_put_attributes}
\title{Put Attributes}
\usage{
ecs_put_attributes(
  cluster = NULL,
  attributes = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{cluster}{String. The short name or full Amazon Resource Name (ARN) of the cluster that contains the resource to apply...}

\item{attributes}{List. The attributes to apply to your resource.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create or update an attribute on an Amazon
ECS resource. If the attribute does not exist, it is created. If the
attribute exists, its value is replaced with the specified value. To
delete an attribute, use DeleteAttributes. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes}{Attributes}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}
\section{cluster}{

The short name or full Amazon Resource
Name (ARN) of the cluster that contains the resource to apply
attributes. If you do not specify a cluster, the default cluster is
assumed.
}

\section{attributes}{

The attributes to apply to your resource.
You can specify up to 10 custom attributes per resource. You can specify
up to 10 attributes in a single call.
}

