% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idnotification.R
\name{get_id_notification}
\alias{get_id_notification}
\alias{set_id_notification}
\title{Get/Set Notifications}
\usage{
get_id_notification(identity, ...)

set_id_notification(identity, type = c("Bounce", "Complaint", "Delivery"),
  topic, ...)
}
\arguments{
\item{identity}{An SES identity.}

\item{type}{A character string specifying a notification type.}

\item{topic}{An SNS topic name. See \code{\link[aws.sns]{create_topic}}}

\item{\dots}{Additional arguments passed to \code{\link{sesPOST}}.}
}
\description{
Get/Set ID Notifications
}
\examples{
\dontrun{
# get
get_id_notifiaction("example@example.com")

# set
if (require("aws.sns")) {
  top <- create_topic("ses_email_bounce")
  set_id_notifiaction("example@example.com", "Bounce", top)
  get_id_notifiaction("example@example.com")
  
  # cleanup
  delete_topic(top)
}
}
}
\seealso{
\code{\link{verify_id}}, \code{\link[aws.sns]{create_topic}}
}

