% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land_simulate.R
\name{land_simulate}
\alias{land_simulate}
\title{Simulate Land Battles}
\usage{
land_simulate(
  offense_infantry = 0,
  offense_artillery = 0,
  offense_tanks = 0,
  offense_fighters = 0,
  offense_bombers = 0,
  defense_infantry = 0,
  defense_artillery = 0,
  defense_tanks = 0,
  defense_fighters = 0,
  defense_bombers = 0,
  aagun = FALSE,
  bombarding_battleships = 0,
  bombarding_cruisers = 0,
  sample_size = 10000,
  decimals = 1,
  write_to_console = TRUE
)
}
\arguments{
\item{offense_infantry}{Number of infantry on the attacking side, which hit when the dice roll is a 1}

\item{offense_artillery}{Number of artillery on the attacking side, which hit when the dice roll is a 2 or less}

\item{offense_tanks}{Number of tanks on the attacking side, which hit when the dice roll is a 3 or less}

\item{offense_fighters}{Number of fighters on the attacking side, which hit when the dice roll is a 3 or less}

\item{offense_bombers}{Number of bombers on the attacking side, which hit when the dice roll is a 4 or less}

\item{defense_infantry}{Number of infantry on the defending side, which hit when the dice roll is a 2 or less}

\item{defense_artillery}{Number of artillery on the defending side, which hit when the dice roll is a 2 or less}

\item{defense_tanks}{Number of tanks on the defending side, which hit when the dice roll is a 3 or less}

\item{defense_fighters}{Number of infantry on the defending side, which hit when the dice roll is a 4 or less}

\item{defense_bombers}{Number of infantry on the defending side, which hit when the dice roll is a 1 or less}

\item{aagun}{Whether or not an Anti-Air gun is present, which rolls one time at the beginning of the battle for each attacking aircraft, and hits if the roll is a 1}

\item{bombarding_battleships}{Number of bombarding battleships, which bombard at the start of the battle, and hit at 4 or less}

\item{bombarding_cruisers}{Number of bombarding cruisers, which bombard at the start of the battle, and hit at 3 or less}

\item{sample_size}{Number of land battles simulated}

\item{decimals}{Number of decimal places the percentages are rounded to}

\item{write_to_console}{If true, writes the output to the console, if false, returns as a vector}
}
\value{
Percentage of the land battles won and lost.
}
\description{
Simulates a number of land battles and gives the percentage of them won and lost. Use to find the probability of winning a particular land battle.
}
\examples{
land_simulate(offense_infantry = 10, defense_infantry = 6, decimals = 2)


}
