% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimTools.R
\name{getError}
\alias{getError}
\title{getError}
\usage{
getError(res, conf)
}
\arguments{
\item{res}{Results from \code{getDailyMaxResults}.}

\item{conf}{configuration}
}
\value{
This function returns a num value, that represents the combined rmse from the beds.
}
\description{
Determine error from babsim runs. 
This error is the sum of the RMSE values for bed, intensiveBed, and intensiveBedVentilation.
}
\examples{
para = babsimHospitalPara()
conf = babsimToolsConf()
data = getObkData()
set.seed(conf$seed)
para <- checkSimPara(para)
arrivalTimes <- getArrivalTimes(data$simData$Infected)
envs <- babsimHospital(arrivalTimes = arrivalTimes,
                         conf = conf,
                         para = para)
fieldEvents <- getRealBeds(data = data$fieldData,
                           resource= conf$ResourceNames)
res <- getDailyMaxResults(envs = envs,  
                          fieldEvents = fieldEvents,
                          conf = conf)
err <- getError(res, conf = conf)

}
