% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babsimTools.R
\name{weighted_rmse}
\alias{weighted_rmse}
\title{weighted_rmse}
\usage{
weighted_rmse(
  actual,
  predicted,
  weights = exp(-(length(actual):1)/14),
  worsenGoodExpections = 1.5
)
}
\arguments{
\item{actual}{Real Data, vector of observations}

\item{predicted}{Predicted Data, vector of observations}

\item{weights}{Time based decay. Default is an exponential decay}

\item{worsenGoodExpections}{Factor by how much predicting too few used ressources should be punished more.}
}
\value{
weighted RMSE
}
\description{
Calculate a weighted RMSE. Weights are based on "time" in the case of the weights variable. 
(E.g. older errors weigh less). And also based on the "direction" e.g. predicting to few used ressources
is worse than predicting a few ressources used too much.
}
