% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{RW2}
\alias{RW2}
\title{Second-Order Random Walk Prior}
\usage{
RW2(s = 1, along = NULL)
}
\arguments{
\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_rw2"}.
}
\description{
Use a second-oder random walk to model
a main effect, or use multiple second-order random walks
to model an interaction.
A second-order random walk is effectively
a random walk with drift where the
drift term varies. It is typically
used with main effects or interactions
that involve time, where there are sustained
trends upward or downward.
}
\details{
If \code{RW2()} is used with an interaction,
separate series are used for
the "along" variable within
each combination of the
"by" variables.

Argument \code{s} controls the size of innovations in the random walk.
Smaller values for \code{s} tend to give smoother series.

Argument \code{n_seas} controls the number of \code{seasons}.
When using quarterly data, for instance,
\code{n_seas} should be \code{4}, and when using
monthly data, \code{n_seas} should be \code{12}.

By default, the magnitude of seasonal effects
can change over time. However, setting \code{s_seas}
to \code{0} produces seasonal effects that are fixed,
eg where "January" effect is the same every year,
the "Feburary" effect is the same every year, and so on.
}
\section{Mathematical details}{


When \code{RW()} is used with a main effect,

\deqn{\beta_j = 2 \beta_{j-1} - \beta_{j-2} + \epsilon_j}
\deqn{\epsilon_j \sim \text{N}(0, \tau^2),}

and when it is used with an interaction,

\deqn{\beta_{u,v} = 2\beta_{u,v-1} - \beta_{u,v-2} + \epsilon_{u,v}}
\deqn{\epsilon_{u,v} \sim \text{N}(0, \tau^2),}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the "along" variable of the interaction; and
\item \eqn{u} denotes position within the "by" variable(s) of the interaction.
}

Parameter \eqn{\tau}
has a half-normal prior
\deqn{\tau \sim \text{N}^+(0, \text{s}^2),}
where \code{s} is provided by the user.
}

\examples{
RW2()
RW2(s = 0.5)
}
\seealso{
\itemize{
\item \code{\link[=RW]{RW()}} Random walk
\item \code{\link[=AR]{AR()}} Autoregressive with order k
\item \code{\link[=AR1]{AR1()}} Autoregressive with order 1
\item \code{\link[=Sp]{Sp()}} Smoothing via splines
\item \code{\link[=SVD]{SVD()}} Smoothing of age via singular value decomposition
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
}
}
