% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagreg.R
\name{bagreg}
\alias{bagreg}
\title{Bagged CV bandwidth selector for Nadaraya-Watson estimator}
\usage{
bagreg(x, y, r, s, h0, h1, nb = r, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Covariate vector.}

\item{y}{Response vector.}

\item{r}{Positive integer. Size of the subsamples.}

\item{s}{Positive integer. Number of subsamples.}

\item{h0}{Positive real number. Range over which to minimize, left bound.}

\item{h1}{Positive real number. Range over which to minimize, right bound.}

\item{nb}{Positive integer. Number of bins to use in cross-validation.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Bagged CV bandwidth.
}
\description{
Bagged CV bandwidth selector for Nadaraya-Watson estimator
}
\details{
Bagged cross-validation bandwidth selector for the Nadaraya-Watson estimator.
}
\examples{
set.seed(1)
x <- rnorm(10^5)
y <- 2*x+rnorm(1e5,0,0.5)
bagreg(x, y, 1000, 10, 0.01, 1, 1000, 2)

}
