% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_inputs.R
\name{convert_inputs}
\alias{convert_inputs}
\title{Convert inputs for baggr models}
\usage{
convert_inputs(data, model, quantiles, group = "group",
  outcome = "outcome", treatment = "treatment", test_data = NULL)
}
\arguments{
\item{data}{`data.frame`` with desired modelling input}

\item{model}{valid model name used by baggr;
see \link{baggr} for allowed models
if \code{model = NULL}, this function will try to find appropriate model
automatically}

\item{quantiles}{vector of quantiles to use (only applicable if \code{model = "quantiles"})}

\item{group}{name of the column with grouping variable}

\item{outcome}{name of column with outcome variable (designated as string)}

\item{treatment}{name of column with treatment variable}

\item{test_data}{same format as \code{data} argument, gets left aside for
testing purposes (see \link{baggr})}
}
\value{
R structure that's appropriate for use by \link{baggr} Stan models;
\code{group_label}, \code{model} and \code{n_groups} are included as attributes
and are necessary for \link{baggr} to work correctly
}
\description{
Converts data to Stan inputs, checks integrity of data
and suggests default model if needed. Typically used
automatically by \link{baggr} but useful for debugging.
}
\details{
Typically this function is only called within \link{baggr} and you do
not need to use it yourself. It can be useful to understand inputs
or to run models which you modified yourself.
}
\examples{
# simple meta-analysis example:
convert_inputs(schools, "rubin")
}
\author{
Witold Wiecek, Rachael Meager
}
