% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_inputs.R
\name{convert_inputs}
\alias{convert_inputs}
\title{Convert inputs for baggr models}
\usage{
convert_inputs(
  data,
  model,
  quantiles,
  effect = NULL,
  group = "group",
  outcome = "outcome",
  treatment = "treatment",
  covariates = c(),
  test_data = NULL,
  silent = FALSE
)
}
\arguments{
\item{data}{`data.frame`` with desired modelling input}

\item{model}{valid model name used by baggr;
see \link{baggr} for allowed models
if \code{model = NULL}, this function will try to find appropriate model
automatically}

\item{quantiles}{vector of quantiles to use (only applicable if \code{model = "quantiles"})}

\item{effect}{Only matters for binary data, use \code{logOR}, \code{logRR}, or \code{RD}. Otherwise ignore.
See \link{prepare_ma} for details.}

\item{group}{name of the column with grouping variable}

\item{outcome}{name of column with outcome variable (designated as string)}

\item{treatment}{name of column with treatment variable}

\item{covariates}{Character vector with column names in \code{data}.
The corresponding columns are used as
covariates (fixed effects) in the meta-regression model.}

\item{test_data}{same format as \code{data} argument, gets left aside for
testing purposes (see \link{baggr})}

\item{silent}{Whether to print messages when evaluated}
}
\value{
R structure that's appropriate for use by \link{baggr} Stan models;
\code{group_label}, \code{model}, \code{effect} and \code{n_groups} are included as attributes
and are necessary for \link{baggr} to work correctly
}
\description{
Converts data to a list of inputs suitable for Stan models,
checks integrity of data and suggests the appropriate default model
if needed. Typically all of this is
done automatically by \link{baggr}, so \strong{this function is included only for debugging}
or running (custom) models "by hand".
}
\details{
Typically this function is only called within \link{baggr} and you do
not need to use it yourself. It can be useful to understand inputs
or to run models which you modified yourself.
}
\examples{
# simple meta-analysis example,
# this is the formatted input for Stan models in baggr():
convert_inputs(schools, "rubin")
}
\author{
Witold Wiecek
}
