% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_wrapper.R
\name{t_test}
\alias{t_test}
\title{Student's t-test}
\usage{
t_test(x, ...)
}
\arguments{
\item{x}{An object for which an S3 method of t.test exists (vector or
formula).}

\item{\dots}{arguments passed to \code{\link[stats]{t.test}}.}
}
\value{
A list with class \code{"t_test"} containing the following
components: \item{statistic}{the value of the t-statistic.}
\item{parameter}{the degrees of freedom for the t-statistic.}
\item{p.value}{the p-value for the test.} \item{conf.int}{a confidence
interval for the mean appropriate to the specified alternative hypothesis.}
\item{estimate}{the estimated mean or difference in means depending on
whether it was a one-sample test or a two-sample test.}
\item{null.value}{the specified hypothesized value of the mean or mean
difference depending on whether it was a one-sample test or a two-sample
test.} \item{alternative}{a character string describing the alternative
hypothesis.} \item{method}{a character string indicating what type of t-test
was performed.} \item{data.name}{a character string giving the name(s) of
the data.}\item{v}{The variance or group-specific variances.}\item{n}{The
sample size, or group-specific sample size.}
}
\description{
This function is a wrapper for the function \code{\link[stats]{t.test}},
which returns group-specific sample sizes and variances, in addition to the
usual output of \code{\link[stats]{t.test}}.
}
\details{
This wrapper allows users to enjoy the functionality of bain with the
familiar interface of the stats-function t.test.

For more documentation, see \code{\link[stats]{t.test}}.
}
\examples{
tmp <- t_test(extra ~ group, data = sleep)
tmp$n
tmp$v
tmp2 <- t_test(extra ~ group, data = sleep)
tmp2$n
tmp2$v
tmp <- t_test(extra ~ group, data = sleep, paired = TRUE)
tmp$n
tmp$v
tmp2 <- t_test(extra ~ group, data = sleep, paired = TRUE)
tmp2$n
tmp2$v
t_test(sesamesim$postnumb)
tmp <- t_test(sesamesim$prenumb)
tmp$n
tmp$v
tmp2 <- t_test(sesamesim$prenumb)
tmp2$n
tmp2$v
tmp <- t_test(sesamesim$prenumb, sesamesim$postnumb)
tmp$n
tmp$v
tmp2 <- t_test(sesamesim$prenumb, sesamesim$postnumb)
tmp2$n
tmp2$v
tmp <- t_test(sesamesim$prenumb, sesamesim$postnumb, paired = TRUE)
tmp$n
tmp$v
tmp2 <- t_test(sesamesim$prenumb, sesamesim$postnumb, paired = TRUE)
tmp2$n
tmp2$v
}
\seealso{
\code{\link[stats]{t.test}}
}
\keyword{htest}
