% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bakRData.R
\name{bakRData}
\alias{bakRData}
\title{bakR Data object helper function for users}
\usage{
bakRData(cB, metadf)
}
\arguments{
\item{cB}{Dataframe with columns corresponding to feature ID, number of Ts, number of mutations, sample ID, and number of identical observations}

\item{metadf}{Dataframe detailing s4U label time and experimental ID of each sample}
}
\value{
A bakRData object. This has two components: a data frame describing experimental
details (metadf) and a data frame containing the NR-seq data (cB).
}
\description{
This function creates an object of class bakRData
}
\examples{
# Load cB
data("cB_small")

# Load metadf
data("metadf")

# Create bakRData object
bakRData <- bakRData(cB_small, metadf)

}
