% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitting_Models.R
\name{bakRFit}
\alias{bakRFit}
\title{Estimating kinetic parameters from nucleotide recoding RNA-seq data}
\usage{
bakRFit(
  obj,
  StanFit = FALSE,
  HybridFit = FALSE,
  high_p = 0.2,
  totcut = 50,
  Ucut = 0.25,
  AvgU = 4,
  FastRerun = FALSE,
  FOI = c(),
  concat = TRUE,
  StanRateEst = FALSE,
  RateEst_size = 30,
  low_reads = 100,
  high_reads = 5e+05,
  chains = 1,
  NSS = FALSE,
  Chase = FALSE,
  BDA_model = FALSE,
  ...
)
}
\arguments{
\item{obj}{bakRData object produced by \code{bakRData} or a bakRFit object produced by \code{bakRFit}}

\item{StanFit}{Logical; if TRUE, then the MCMC implementation is run. Will only be used if \code{obj}
is a \code{bakRFit} object}

\item{HybridFit}{Logical; if TRUE, then the Hybrid implementation is run. Will only be used if \code{obj}
is a \code{bakRFit} object}

\item{high_p}{Numeric; Any transcripts with a mutation rate (number of mutations / number of Ts in reads) higher than this in any -s4U control
samples (i.e., samples that were not treated with s4U) are filtered out}

\item{totcut}{Numeric; Any transcripts with less than this number of sequencing reads in any sample are filtered out}

\item{Ucut}{Numeric; All transcripts must have a fraction of reads with 2 or less Us less than this cutoff in all samples}

\item{AvgU}{Numeric; All transcripts must have an average number of Us greater than this cutoff in all samples}

\item{FastRerun}{Logical; only matters if a bakRFit object is passed to \code{bakRFit}. If TRUE, then the Stan-free
model implemented in \code{fast_analysis} is rerun on data, foregoing fitting of either of the 'Stan' models.}

\item{FOI}{Features of interest; character vector containing names of features to analyze}

\item{concat}{Logical; If TRUE, FOI is concatenated with output of reliableFeatures}

\item{StanRateEst}{Logical; if TRUE, a simple 'Stan' model is used to estimate mutation rates for fast_analysis; this may add a couple minutes
to the runtime of the analysis.}

\item{RateEst_size}{Numeric; if StanRateEst is TRUE, then data from RateEst_size genes are used for mutation rate estimation. This can be as low
as 1 and should be kept low to ensure maximum efficiency}

\item{low_reads}{Numeric; if StanRateEst is TRUE, then only features with more than low_reads reads in all samples will be used for mutation rate estimation}

\item{high_reads}{Numeric; if StanRateEst is TRUE, then only features with less than high_read reads in all samples will be used for mutation rate estimation.
A high read count cutoff is as important as a low read count cutoff in this case because you don't want the fraction labeled of chosen features to be
extreme (e.g., close to 0 or 1), and high read count features are likely low fraction new features.}

\item{chains}{Number of Markov chains to sample from. 1 should suffice since these are validated models. Running more chains is generally
preferable, but memory constraints can make this unfeasible.}

\item{NSS}{Logical; if TRUE, logit(fn)s are directly compared to avoid assuming steady-state}

\item{Chase}{Logical; Set to TRUE if analyzing a pulse-chase experiment. If TRUE, kdeg = -ln(fn)/tl where fn is the fraction of
reads that are s4U (more properly referred to as the fraction old in the context of a pulse-chase experiment).}

\item{BDA_model}{Logical; if TRUE, variance is regularized with scaled inverse chi-squared model. Otherwise a log-normal
model is used.}

\item{...}{Arguments passed to either \code{fast_analysis} (if a bakRData object)
or \code{TL_Stan} and \code{Hybrid_fit} (if a bakRFit object)}
}
\value{
bakRFit object with results from statistical modeling and data processing. Objects possibly included are:
\itemize{
\item Fast_Fit; Always will be present. Output of \code{fast_analysis}
\item Hybrid_Fit; Only present if HybridFit = TRUE. Output of \code{TL_stan}
\item Stan_Fit; Only present if StanFit = TRUE. Output of \code{TL_stan}
\item Data_lists; Always will be present. Output of \code{cBprocess} with Fast and Stan == TRUE
}
}
\description{
\code{bakRFit} analyzes nucleotide recoding RNA-seq data to estimate
kinetic parameters relating to RNA stability and changes in RNA
stability induced by experimental perturbations. Several statistical
models of varying efficiency and accuracy can be used to fit data.
}
\details{
If \code{bakRFit} is run on a bakRData object, \code{cBprocess}
and then \code{fast_analysis} will always be called. The former will generate the processed
data that can be passed to the model fitting functions (\code{fast_analysis}
and \code{TL_Stan}). The call to \code{fast_analysis} will generate a list of dataframes
containing information regarding the \code{fast_analysis} fit. \code{fast_analysis} is always
called because its output is required for both \code{Hybrid_fit} and \code{TL_Stan}.

If \code{bakRFit} is run on a bakRFit object, \code{cBprocess} will not be called again,
as the output of \code{cBprocess} will already be contained in the bakRFit object. Similarly,
\code{fast_analysis} will not be called again unless bakRFit is rerun on the bakRData object.
or if \code{FastRerun} is set to TRUE. If you want to generate model fits using different parameters for cBprocess,
you will have to rerun \code{bakRFit} on the bakRData object.

See the documentation for the individual fitting functions for details regarding how they analyze nucleotide
recoding data. What follows is a brief overview of how each works

\code{fast_analysis} (referred to as the MLE implementation in the bakR paper)
either estimates mutation rates from + and (if available) - s4U samples or uses mutation rate estimates
provided by the user to perform maximum likelihood estimation (MLE) of the fraction of RNA that is labeled for each
replicate of nucleotide recoding data provided. Uncertainties for each replicate's estimate are approximated using
asymptotic results involving the Fisher Information and assuming known mutation rates. Replicate data
is pooled using an approximation to hierarchical modeling that relies on analytic solutions to simple Bayesian models.
Linear regression is used to estimate the relationship between read depths and replicate variability for uncertainty
estimation regularization, again performed using analytic solutions to Bayesian models.

\code{TL_Stan} with Hybrid_Fit set to TRUE (referred to as the Hybrid implementation in the bakR paper)
takes as input estimates of the logit(fraction new) and uncertainty provided by \code{fast_analysis}.
It then uses 'Stan' on the backend to implement a hierarchical model that pools data across replicates and the dataset
to estimate effect sizes (L2FC(kdeg)) and uncertainties. Replicate variability information is pooled across each experimental
condition to regularize variance estimates using a hierarchical linear regression model.

The default behavior of \code{TL_Stan} (referred to as the MCMC implementation in the bakR paper)
is to use 'Stan' on the back end to implement a U-content exposure adjusted Poisson mixture model
to estimate fraction news from the mutational data. Partial pooling of replicate variability estimates
is performed as with the Hybrid implementation.
}
\examples{
\donttest{
# Simulate data for 1000 genes, 2 replicates, 2 conditions
simdata <- Simulate_bakRData(1000, nreps = 2)

# You always must fit fast implementation before any others
Fit <- bakRFit(simdata$bakRData)

}

}
