% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metadiag.R
\name{metadiag}
\alias{metadiag}
\title{Bayesian Meta-Analysis of diagnostic test data}
\usage{
metadiag(data, re = "normal", link = "logit", mean.mu.D = 0,
  mean.mu.S = 0, sd.mu.D = 10, sd.mu.S = 10, sigma.D.upper = 10,
  sigma.S.upper = 10, mean.Fisher.rho = 0, sd.Fisher.rho = 1/sqrt(2),
  df = 4, split.w = FALSE, n.1.new = 50, n.2.new = 50, nr.chains = 2,
  nr.iterations = 5000, nr.adapt = 1000, nr.burnin = 1000, nr.thin = 1,
  be.quiet = FALSE, r2jags = TRUE)
}
\arguments{
\item{data}{A data frame with at least 4 columns containing the true positives (tp),
number of patients with disease (n1), false positives (fp), number of patients without
disease (n2)}

\item{re}{Random effects distribution for the resulting model. Possible
values are \emph{normal} for bivariate random effects and \emph{sm} for scale mixtures}

\item{link}{The link function used in the model. Possible values are
\emph{logit}, \emph{cloglog} \emph{probit}.}

\item{mean.mu.D}{prior mean of D, default value is 0}

\item{mean.mu.S}{prior mean of S, default value is 0}

\item{sd.mu.D}{prior standard deviation of D, default value is 10}

\item{sd.mu.S}{prior standard deviation of S, default value is 10}

\item{sigma.D.upper}{upper bound of the uniform prior of sigma.S default value is 10}

\item{sigma.S.upper}{upper bound of the uniform prior of sigma.S default value is 10}

\item{mean.Fisher.rho}{mean of rho in the Fisher scale default value is 0}

\item{sd.Fisher.rho}{standard deviation of rho in the Fisher scale default value is 1/sqrt(2)}

\item{df}{Degrees of freedom for the scale mixture distribution default value is 4}

\item{split.w}{Split the w parameter in two indpendentent weights one for each random effect. The defualt value is FALSE.}

\item{n.1.new}{Number of patients with desease in a predictive study default is 50}

\item{n.2.new}{Number of patients with non-desease in a predictive study default is 50}

\item{nr.chains}{Number of chains for the MCMC computations default 5}

\item{nr.iterations}{Number of iterations after adapting the MCMC default is 1000}

\item{nr.adapt}{Number of iterations in the adaptation process defualt is 500}

\item{nr.burnin}{Number of interation descared for burnin period default is 500}

\item{nr.thin}{Thinning rate, it must be a positive integer the defulat value 1}

\item{be.quiet}{Do not print warning message if the model does not adapt default value is FALSE}

\item{r2jags}{Which interface is used to link R to JAGS (rjags and R2jags) default value is R2Jags TRUE}
}
\description{
This function performers a Bayesian meta-analysis of diagnostic test data by
fitting a bivariate random effects model. The number of true positives and
false positives are modeled with two conditional Binomial distributions and
the random-effects are based on a bivariate scale mixture of Normals.
Computations are done by calling JAGS (Just Another Gibbs Sampler) to perform
MCMC (Markov Chain Monte Carlo) sampling and returning an object of the
class \emph{mcmc.list}.
}
\examples{
## execute analysis
\dontrun{
data(mri)
mri
md <- metadiag(mri)
summary(md)
}
}
\keyword{file}

