% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model2sparse.R
\name{model2sparse}
\alias{model2sparse}
\title{model2sparse: Converts a niche model into a diagonal sparse matrix}
\usage{
model2sparse(model, threshold = NULL)
}
\arguments{
\item{model}{A raster object representing the geographic projection
of a niche model.}

\item{threshold}{A threshold to convert a continuous model into a
binary model.}
}
\value{
An object of class \code{\link[bamm]{setA}}. The niche model
is stored as diagonal sparse matrix (slot sparse_model).
}
\description{
model2sparse: Converts a niche model into a diagonal sparse matrix
}
\details{
threshold parameter represents the suitability value used to
convert continuous model into a binary model.
}
\examples{
model_path <- system.file("extdata/Lepus_californicus_cont.tif",
                          package = "bamm")
model <- raster::raster(model_path)

sparse_mod <- bamm::model2sparse(model, threshold=0.75)
print(sparse_mod)
raster::plot(sparse_mod@niche_model)
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
