% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-lange.R
\encoding{UTF-8}
\name{model.lange.apply}
\alias{model.lange.apply}
\title{Use the Lange model}
\arguments{
\item{tmin, tmean, tmax}{Daily minimum/mean/maximum temperatures in °C.}

\item{.submodels, .onset, .diapause, .mortality, ...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}
}
\value{
The function returns a phenology. Look \link[=analyse.phenology]{here} to find out how it can be analysed.
}
\description{
This page describes the usage of the the Lange model with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
The model was published by \insertCite{Lange2008;textual}{barrks} for
\emph{Ips typographus}.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply the Lange model and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("lange", ..., tmin, tmean, tmax)

# calculate submodels separately
phenology("lange", ..., .submodels = 'onset', tmean, tmax)
phenology("lange", ..., .submodels = 'mortality', tmin)
phenology("lange", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmean, tmax)
}\if{html}{\out{</div>}}
}
\section{Functioning}{


In the following, the basic functioning of the Lange model is explained.
\itemize{
\item \strong{Onset}: The onset of swarming is triggerd when the degree days of the maximum temperature reach
a specific threshold and the maximum temperature exceeds the minimum flight temperature
according to \insertCite{Annila1969;textual}{barrks}.
\item \strong{Development}: The development is calculated using stage-specific
temperature sums and thresholds \insertCite{Wermelinger1998}{barrks}.
A new generation starts its development when the last generation finished its
development and the maximum temperature exceeds the minimum flight temperature.
\item \strong{Diapause}: The Lange model does not have a diapause submodel implemented.
\item \strong{Mortality}: White stages (egg to pupa) die when the minimum temperature
falls below a specific threshold.
}

Look \link[=model.lange.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.lange.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.chapy.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.phenips_clim.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
