% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-phenips.R
\encoding{UTF-8}
\name{model.phenips.apply}
\alias{model.phenips.apply}
\title{Use PHENIPS}
\arguments{
\item{...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}

\item{tmean, tmax}{Daily mean/maximum temperatures in °C.}

\item{rad}{Daily radiation in W * h / m^2.}

\item{daylength}{Length of the day in hours. Can be created with
\code{\link[=create_daylength_rst]{create_daylength_rst()}} or \code{\link[=create_daylength_df]{create_daylength_df()}}.}

\item{exposure}{Specifies the sun exposure. Can be \code{'sunny'} (default) or \code{'shaded'}.}

\item{sister_broods}{Set \code{FALSE} if sister broods should not be calculated.}
}
\value{
The function returns a phenology. Look \link[=analyse.phenology]{here} to find out how it can be analysed.
}
\description{
This page describes the usage of PHENIPS with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
PHENIPS was published by \insertCite{Baier2007;textual}{barrks} and
parametrized at the Kalkalpen National Park in Austria for \emph{Ips typographus}.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply PHENIPS and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("phenips", ..., tmean, tmax, rad, daylength,
          exposure = 'sunny', sister_broods = TRUE)

# calculate submodels separately
phenology("phenips", ..., .submodels = 'onset', tmax)
phenology("phenips", ..., .submodels = 'diapause', daylength)
phenology("phenips", ..., .submodels = 'mortality', tmax)
phenology("phenips", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmean, tmax, rad,
          exposure = 'sunny', sister_broods = TRUE)
}\if{html}{\out{</div>}}
}
\section{Functioning}{


In the following, the basic functioning of PHENIPS is explained.
\itemize{
\item \strong{Onset}: The onset is triggered when the degree days of the maximum temperature reach
a specific threshold and the maximum temperature exceeds the minimum flight temperature.
\item \strong{Development}: The beetles develop according to a slightly modified version
of the optimum curve described by \insertCite{Wermelinger1998;textual}{barrks}
depending on the bark temperature. The bark temperature is modeled based on mean
and maximum temperature, global radiation and sun exposure. A new generation will
emerge when the last generation is fully developed and the maximum temperature
exceeds the minimum flight temperature.
\item \strong{Diapause}: The diapause is initiated when the daylength falls below a threshold.
\item \strong{Mortality}: White stages (egg to pupa) die on a fixed date.
}

Look \link[=model.phenips.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.phenips.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.chapy.apply}},
\code{\link{model.joensson.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips_clim.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
