% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-rity.R
\encoding{UTF-8}
\name{model.rity.customize}
\alias{model.rity.customize}
\title{Customize RITY}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_threshold}{Degree days that are required to trigger the onset of
infestation. Additionally, the maximum temperature must exceed \code{tfly}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_onset_base}{Base temperature to calculate degree days for development.}

\item{dd_total_dev}{Degree days that are required for a generation to fully
develop}

\item{dev_start, dev_end}{Share in total development when the egg development starts and the
juvenile beetle's development ends respectively. Usable if the development
below/above these thresholds should account for mating, oviposition etc.}

\item{dev_sister_brood}{Share in the total development, when a sister brood
will be established.}

\item{dev_mortal_min, dev_mortal_max}{The beetles are considered to be in
white stages (egg, larva, pupa) if their development exceeds \code{dev_mortal_min}
and subceeds \code{dev_mortal_max}. During these stages, the beetles could die
due to a mortality event. \code{NULL} means that no lower/upper threshold is
defined.}

\item{func_ftmean, func_ftmax, func_atdiff}{Functions to caclulate the
air temperature in forest stands (see \insertCite{Ogris2019;nobrackets}{barrks},
equations 1 - 3). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{tmin}: min air temperature
\item \code{tmean}: mean air temperature
\item \code{tmax}: maximum air temperature
}}

\item{func_btmean, func_btmax, func_btdiff}{Functions to caclulate the
bark temperature (see \insertCite{Ogris2019;nobrackets}{barrks},
equations 4 - 6). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{ftmin}: min air temperature in forest stands
\item \code{ftmean}: mean air temperature in forest stands
\item \code{ftmax}: maximum air temperature in forest stands
}}

\item{dt_low, dt_up, topt, tmax, alpha, beta, gamma}{Parameters to calculate
the effective bark temperature (see \insertCite{Ogris2019;nobrackets}{barrks},
equations 7 - 9).}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{daylength_dia}{When the daylength falls below this threshold, diapause
will be initiated.}

\item{mortality_date}{Date when all white stages (egg, larva, pupa) die.}
}
\description{
This page describes the parameters
that can be used to customize RITY (also called RITY-2). The model was developed by
\insertCite{Ogris2019;textual}{barrks}. Look \link[=model.rity.apply]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for RITY and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model("rity",

      # ==== onset ====

      dd_onset_start_date = '03-07',
      dd_onset_base = 8.3,
      dd_onset_threshold = 155.6,

      # ==== onset + development ====

      tfly = 14.5,

      # ==== development ====

      dd_development_base = 8.3,
      dd_total_dev = 557,
      dev_start = 0,
      dev_end = 1,
      dev_sister_brood = 0.5,
      dev_mortal_min = NULL,
      dev_mortal_max = 0.6,

      func_ftmin = function(tmin) \{ 1.44 + 0.82 * tmin \},
      func_ftmean = function(tmean) \{ 0.50 + 0.81 * tmean \},
      func_ftmax = function(tmax) \{ 1.03 + 0.86 * tmax \},

      func_btmin = function(ftmin) \{ 0.56 + 0.99 * ftmin \},
      func_btmean = function(ftmean) \{ -0.48 + 1.03 * ftmean \},
      func_btmax = function(ftmax) \{ 0.03 + 0.99 * ftmax \},

      dt_low = 8.3,
      dt_up = 38.9,
      topt = 30.4,
      tmax = 40.9958913,
      alpha = 0.02876507,
      beta = 3.5922336,
      gamma = 1.24657367,

      model_end_date = '10-31',

      # ==== diapause ====

      daylength_dia = 14.5,

      # ==== mortality ====

      mortality_date = '10-31'
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.rity.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.chapy.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.phenips_clim.customize}}
}
\concept{model customizations}
