% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bartDiag.R
\name{bartDiag}
\alias{bartDiag}
\title{bartDiag}
\usage{
bartDiag(
  model,
  data,
  response,
  burnIn = 0,
  threshold = "Youden",
  pNorm = FALSE,
  showInterval = TRUE,
  combineFactors = FALSE
)
}
\arguments{
\item{model}{a model created from either the BART, modelarts, or bartMachine package.}

\item{data}{A dataframe used to build the model.}

\item{response}{The name of the response for the fit.}

\item{burnIn}{Trace plot will only show iterations above selected burn in value.}

\item{threshold}{A dashed line on some plots to indicate a chosen threshold value (classification only).
by default the Youden index is shown.}

\item{pNorm}{apply pnorm to the y-hat data (classification only).}

\item{showInterval}{LOGICAL if TRUE then show 5\% and 95\% quantile intervals on ROC an PC curves (classification only).}

\item{combineFactors}{Whether or not to combine dummy variables (if present) in display.}
}
\value{
A selection of diagnostic plots.
}
\description{
Displays a selection of diagnostic plots for a BART model.
}
\examples{
\donttest{
# For Regression
# Generate Friedman data
fData <- function(n = 200, sigma = 1.0, seed = 1701, nvar = 5) {
  set.seed(seed)
  x <- matrix(runif(n * nvar), n, nvar)
  colnames(x) <- paste0("x", 1:nvar)
  Ey <- 10 * sin(pi * x[, 1] * x[, 2]) + 20 * (x[, 3] - 0.5)^2 + 10 * x[, 4] + 5 * x[, 5]
  y <- rnorm(n, Ey, sigma)
  data <- as.data.frame(cbind(x, y))
  return(data)
}
f_data <- fData(nvar = 10)
x <- f_data[, 1:10]
y <- f_data$y

# Create dbarts model
library(dbarts)
set.seed(1701)
dbartModel <- bart(x, y, ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

bartDiag(model = dbartModel, response = "y", burnIn = 100, data = f_data)


# For Classification
data(iris)
iris2 <- iris[51:150, ]
iris2$Species <- factor(iris2$Species)

# Create dbarts model
dbartModel <- bart(iris2[, 1:4], iris2[, 5], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

bartDiag(model = dbartModel, data = iris2, response = iris2$Species)
}

}
