% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.barp.R
\name{Explain.barp}
\alias{Explain.barp}
\title{Approximate Shapley values computed from the BARP model}
\usage{
\method{Explain}{barp}(
  object,
  feature_names = NULL,
  X = NULL,
  nsim = 1,
  pred_wrapper = NULL,
  census = NULL,
  geo.unit = NULL,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{object}{A BARP model (Bayesian Additive Regression Tree) estimated
using the `barps` function, a modified version of the `barp` function from the BARP library with a fixed seed.}

\item{feature_names}{The name of the variable for which you want to check the contribution.
The default value is set to `NULL`, which means the contribution of all variables in `X` will be calculated.}

\item{X}{The dataset containing all independent variables used as input when estimating the BART model.T he explanatory variables X included in the model must be converted to factors prior to input.}

\item{nsim}{The number of Monte Carlo sampling iterations, which is fixed at `1` by default in the case of the BARP model.}

\item{pred_wrapper}{A function used to estimate the predicted values of the model.}

\item{census}{Census data containing the names of the `X` columns. It should also have the same format as `X` and include a variable named `proportion`, which indicates the number of individuals corresponding to each combination.}

\item{geo.unit}{Enter the name of the stratification variable used in post stratification.}

\item{parallel}{The default value is set to `FALSE`, but it can be changed to `TRUE` for parallel computation.}

\item{...}{Additional arguments to be passed}
}
\value{
Returns of class `Explainbarp` with consisting of a list with the following components:
\item{phis}{A list containing the Shapley values for each variable.}
\item{newdata}{The data used to check the contribution of variables. If a variable has two categories, it is dummy-coded, and if it has three or more categories, categorical variables are one-hot encoded.}
\item{fnull}{The expected value of the model's predictions.}
\item{fx}{The prediction value for each observation.}
\item{factor_names}{The name of the categorical variable. If the data contains only continuous or dummy variables, it is set to NULL.}
}
\description{
This function is implemented to calculate the contribution of each variable
in the BARP (Bayesian Additive Regression Tree with post-stratification) model
using the permutation method.
}
