% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_game_content.R
\name{mlb_game_content}
\alias{mlb_game_content}
\title{\strong{Retrieve additional game content for major and minor league games}}
\usage{
mlb_game_content(game_pk)
}
\arguments{
\item{game_pk}{The unique game_pk identifier for the game}
}
\value{
Returns a tibble of game content data with the following columns:\tabular{ll}{
   col_name \tab types \cr
   title \tab character \cr
   epg_id \tab integer \cr
   content_id \tab character \cr
   media_id \tab character \cr
   media_state \tab character \cr
   media_feed_type \tab character \cr
   media_feed_sub_type \tab character \cr
   call_letters \tab character \cr
   fox_auth_required \tab logical \cr
   tbs_auth_required \tab logical \cr
   espn_auth_required \tab logical \cr
   fs1auth_required \tab logical \cr
   mlbn_auth_required \tab logical \cr
   free_game \tab logical \cr
   type \tab character \cr
   description \tab character \cr
   rendition_name \tab character \cr
   language \tab character \cr
}
}
\description{
\strong{Retrieve additional game content for major and minor league games}
}
\examples{
\donttest{
  try(mlb_game_content(game_pk = 566001))
}
}
