% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fg_milb_pitcher_game_logs.R
\name{fg_milb_pitcher_game_logs}
\alias{fg_milb_pitcher_game_logs}
\title{\strong{Scrape MiLB game logs for pitchers from FanGraphs}}
\usage{
fg_milb_pitcher_game_logs(playerid, year)
}
\arguments{
\item{playerid}{The pitcher's minor league ID from FanGraphs.com.}

\item{year}{The season for which game logs should be returned.}
}
\value{
Returns a tibble of Minor League pitcher game logs.\tabular{ll}{
   col_name \tab types \cr
   player_name \tab character \cr
   minor_playerid \tab character \cr
   Date \tab character \cr
   Team \tab character \cr
   Level \tab character \cr
   Opp \tab character \cr
   W \tab numeric \cr
   L \tab numeric \cr
   ERA \tab numeric \cr
   G \tab numeric \cr
   GS \tab numeric \cr
   CG \tab numeric \cr
   ShO \tab numeric \cr
   SV \tab numeric \cr
   IP \tab numeric \cr
   TBF \tab numeric \cr
   H \tab numeric \cr
   R \tab numeric \cr
   ER \tab numeric \cr
   HR \tab numeric \cr
   BB \tab numeric \cr
   IBB \tab numeric \cr
   HBP \tab numeric \cr
   WP \tab numeric \cr
   BK \tab numeric \cr
   SO \tab numeric \cr
   K/9 \tab numeric \cr
   BB/9 \tab numeric \cr
   K/BB \tab numeric \cr
   HR/9 \tab numeric \cr
   K\% \tab numeric \cr
   K-BB\% \tab numeric \cr
   BB\% \tab numeric \cr
   AVG \tab numeric \cr
   WHIP \tab numeric \cr
   BABIP \tab numeric \cr
   LOB\% \tab numeric \cr
   FIP \tab numeric \cr
   gamedate \tab character \cr
   dh \tab integer \cr
   UPId \tab character \cr
   MLBAMId \tab character \cr
   MinorMasterId \tab character \cr
   RRId \tab character \cr
   FirstName \tab character \cr
   LastName \tab character \cr
   firstLastName \tab character \cr
   Height \tab character \cr
   Weight \tab character \cr
   BirthDate \tab character \cr
   Bats \tab character \cr
   Throws \tab character \cr
   Position \tab character \cr
   BirthCity \tab character \cr
   College \tab character \cr
   Age \tab character \cr
}
}
\description{
This function allows you to scrape MiLB game logs for individual batters from FanGraphs.com.
}
\examples{
\donttest{
  fg_milb_pitcher_game_logs(playerid = "sa3005315", year=2021)
}
}
