% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{read_sql}
\alias{read_sql}
\title{Query out datalake and get results in a tibble}
\usage{
read_sql(query, billing_project_id = get_billing_id(), page_size = 1000)
}
\arguments{
\item{query}{a string containing a valid SQL query.}

\item{billing_project_id}{a string containing your billing project id. If you've run \code{set_billing_id} then feel free to leave this empty.}

\item{page_size}{\code{bigrquery} internal, how many rows per page should there be.}
}
\value{
A tibble containing the query's output.
}
\description{
Query out datalake and get results in a tibble
}
\examples{

\dontrun{

set_billing_id("<your id here>")

query <- "SELECT
pib.id_municipio,
pop.ano,
pib.PIB / pop.populacao * 1000 as pib_per_capita
FROM `basedosdados.br_ibge_pib.municipios` as pib
JOIN `basedosdados.br_ibge_populacao.municipios` as pop
ON pib.id_municipio = pop.id_municipio
LIMIT 5 "

data <- read_sql(query)

# in case you want to write your data on disk as a .xlsx, .csv or .Rds file.

library(writexl)
library(readr)

dir <- tempdir()

write_xlsx(data, file.path(dir, "data.xlsx"))
write_csv(data, file.path(dir, "data.csv"))
saveRDS(data, file.path(dir, "data.Rds"))

}

}
