% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/pow.R
\name{pow}
\alias{pow}
\alias{pow,OneStageBasket-method}
\title{Power}
\usage{
pow(
  design,
  theta1,
  n,
  lambda,
  epsilon,
  tau,
  logbase = 2,
  prune = FALSE,
  results = c("ewp", "group"),
  ...
)

\S4method{pow}{OneStageBasket}(
  design,
  theta1,
  n,
  lambda,
  epsilon,
  tau,
  logbase = 2,
  prune = FALSE,
  results = c("ewp", "group"),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupBasket}.}

\item{theta1}{Probabilities under the alternative hypothesis. If
\code{length(theta1) ==  1}, then this is a common probability for all
baskets.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{epsilon}{A tuning parameter that determines the amount of borrowing.
See details for more information.}

\item{tau}{A tuning parameter that determines how similar the baskets
have to be that borrowing occurs. See details for more information.}

\item{logbase}{A tuning parameter that determines which logarithm base is
used to compute the Jensen-Shannon divergence. See details for more
information.}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.}

\item{results}{Whether only the experimentwise power (option \code{ewp})
or also the rejection probabilities per group (option \code{group}) should
be returned.}

\item{...}{Further arguments.}
}
\value{
If \code{results = "ewp"} then the experimentwise power is
returned as a numeric value. If \code{results = "group"} then a list with
the rejection probabilities per group and the experimentwise power
is returned. For baskets with theta1 = theta0 the rejection probabilities
corresponds to the type 1 error rate, for baskets with theta1 > theta0 the
rejection probabilities corresponds to the power.
}
\description{
Computes the exact power for a basket trial.
}
\details{
\code{pow} computes the exact experimentwise power and the
exact rejection probabilities per group. The experimentwise power
is the probability to reject at least one null hypothesis for a basket with
theta1 > theta0. The rejection probabilities correspond to the type 1 error
rate for baskets with theta1 = theta 0 and to the power for baskets with
theta1 > theta 0.

If \code{prune = TRUE} then the baskets with an observed number of baskets
smaller than the pooled critical value are not borrowed from. The
pooled critical value is the smallest integer c for which all null
hypotheses can be rejected if the number of responses is exactly c for
all baskets.

This method is implemented for the class \code{\link{OneStageBasket}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{OneStageBasket}: Power for a single-stage basket design.
}}

\examples{
design <- setupOneStageBasket(k = 3, theta0 = 0.2)
pow(design, theta1 = c(0.2, 0.5, 0.5), n = 15, lambda = 0.99, epsilon = 2,
  tau = 0)
}
