% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bayesianVARs_predict}
\alias{plot.bayesianVARs_predict}
\title{Fan chart}
\usage{
\method{plot}{bayesianVARs_predict}(
  x,
  dates = NULL,
  vars = "all",
  ahead = NULL,
  quantiles = c(0.05, 0.25, 0.5, 0.75, 0.95),
  n_col = 1L,
  first_obs = 1L,
  ...
)
}
\arguments{
\item{x}{An object of type \code{bayesianVARs_predict} obtained via
\code{\link[=predict.bayesianVARs_bvar]{predict.bayesianVARs_bvar()}}.}

\item{dates}{optional vector of dates for labeling the x-axis. The default
values is \code{NULL}; in this case, the axis will be labeled with numbers.}

\item{vars}{character vector containing the names of the variables to be
visualized. The default is \code{"all"} indicating that all variables are
visualized.}

\item{ahead}{Integer vector (or coercible to such) indicating which step
ahead to plot. \code{max(ahead)} must be smaller equal to
\code{dim(x$predictions)[1]}.}

\item{quantiles}{numeric vector indicating which quantiles to plot.}

\item{n_col}{integer indicating the number of columns to use for plotting.}

\item{first_obs}{integer indicating the first observation to be used for plotting.}

\item{...}{Currently ignored!}
}
\value{
Returns \code{x} invisibly!
}
\description{
Visualization of (out-of-sample) predictive distribution.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Simulate from posterior predictive
predictions <- predict(mod, ahead = 1:3)

# Visualize
plot(predictions, vars = 1:3, ahead = 1:3)
}
\seealso{
Other plotting \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}},
\code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}}, \code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}}
\code{\link[=posterior_heatmap]{posterior_heatmap()}}.
}
