% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrBase_baseDay2decimal.R
\name{baseDay2decimal}
\alias{baseDay2decimal}
\title{Base Day}
\usage{
baseDay2decimal(x)
}
\arguments{
\item{x}{a vector of baseDay values, character, or factors of the form month 
abbreviation and day number, generally created from \code{baseDay}. Missing 
values are permitted and result in missing values in the output. Unmatched 
values also result in missing values in the output.}
}
\value{
A numeric value representing the base day.
}
\description{
Computes the decimal time representation of the base day of the year.  
From smwrBase package.
}
\examples{
# The baseDay ordered by calendar year
bd.tmp <- baseDay(c("2000-02-29", "2000-03-01", "2001-03-01"), 
  numeric=FALSE)
baseDay2decimal(bd.tmp)
# ordered by water year, result should agree
bd.tmp <- baseDay(c("2000-02-29", "2000-03-01", "2001-03-01"), 
  numeric=FALSE, year="water")
baseDay2decimal(bd.tmp)
}
\seealso{
\code{\link{baseDay}}
}
\keyword{internal}
\keyword{manip}
