% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecb.R
\name{ecb_metadata}
\alias{ecb_metadata}
\title{Fetch European Central Bank (ECB) metadata}
\source{
\url{https://data.ecb.europa.eu/help/api/metadata}
}
\usage{
ecb_metadata(type, agency = NULL, id = NULL)
}
\arguments{
\item{type}{(\code{character(1)})\cr
The type of metadata to query. One of: \code{"datastructure"}, \code{"dataflow"}, \code{"codelist"}, or
\code{"concept"}.}

\item{agency}{(\code{NULL} | \code{character(1)})\cr
The id of the agency to query. Default \code{NULL}.}

\item{id}{(\code{NULL} | \code{character(1)})\cr
The id of the resource to query. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested metadata.
The columns are:
\item{agency}{The agency of the metadata}
\item{id}{The id of the metadata}
\item{name}{The name of the metadata}
}
\description{
Retrieve metadata from the ECB time series database via the SDMX Web Service.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
ecb_metadata("datastructure")
ecb_metadata("datastructure", "ECB")
ecb_metadata("datastructure", "ECB", "ECB_EXR1")
ecb_metadata("datastructure", id = "ECB_EXR1")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other metadata: 
\code{\link{bbk_metadata}()},
\code{\link{onb_dimension}()},
\code{\link{onb_frequency}()},
\code{\link{onb_hierarchy}()},
\code{\link{onb_metadata}()},
\code{\link{onb_toc}()}
}
\concept{metadata}
