% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{vcov.bbreg}
\alias{vcov.bbreg}
\title{vcov.bbreg}
\usage{
\method{vcov}{bbreg}(object, parameters = c("all", "mean", "precision"), ...)
}
\arguments{
\item{object}{an object of class "bbreg" containing results from the fitted model.}

\item{parameters}{a string to determine which coefficients should be extracted: 'all' extracts all coefficients, 'mean' extracts the coefficients of the mean parameters and 'precision' extracts coefficients of the precision parameters.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Function to extract the variance-covariance matrix of the parameters of the fitted regression model (bessel or beta).
}
\examples{
\donttest{
fit = bbreg(agreement ~ priming + eliciting|priming, data = WT)
vcov(fit)
vcov(fit, parameters = "precision")}
}
\seealso{
\code{\link{infmat_bes}}, \code{\link{infmat_bet}}
}
