% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{marginalLikelihood_bySufficientStatistics.GaussianNIW}
\alias{marginalLikelihood_bySufficientStatistics.GaussianNIW}
\title{Marginal likelihood of a "GaussianNIW" object, usnig sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{GaussianNIW}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-NIW case the sufficient statistic of sample x is a object of type "ssGaussian", it can be  generated by the function sufficientStatistics().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of a set of observations of the following model structure: \cr
     theta|gamma ~ NIW(gamma) \cr
     x|theta ~ Gaussian(theta) \cr
where theta = (mu,Sigma) is the Gaussian parameter, gamma = (m,k,v,S) is the Normal-Inverse-Wishart(NIW) parameter. \cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
Marginal likelihood is the likelihood of x|gamma.
}
\examples{
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
marginalLikelihood(obj = obj,x=x)
## or...
ss <- sufficientStatistics(obj=obj,x=x,foreach = FALSE)
marginalLikelihood_bySufficientStatistics(obj = obj,ss=ss)
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
@seealso \code{\link{GaussianNIW}}, \code{\link{marginalLikelihood.GaussianNIW}}
}
