% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.CatDP}
\alias{rPosteriorPredictive.CatDP}
\title{Posterior predictive random generation of a "CatDP" object}
\usage{
\method{rPosteriorPredictive}{CatDP}(obj, n = 1L, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{n}{integer, number of samples.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     x|pi ~ Categorical(pi) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
Posterior predictive is a distribution of x|alpha.
}
\examples{
x <- sample(1L:10L,size = 40,replace = TRUE)
obj <- CatDP()
ss <- sufficientStatistics(obj=obj,x=x)
posterior(obj = obj,ss = ss)
rPosteriorPredictive(obj = obj,n=200L)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
@seealso \code{\link{CatDP}}, \code{\link{dPosteriorPredictive.CatDP}}
}
