% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics_Weighted.HDP}
\alias{sufficientStatistics_Weighted.HDP}
\title{Weighted sufficient statistics of a "HDP" object}
\usage{
\method{sufficientStatistics_Weighted}{HDP}(obj, x, w, ...)
}
\arguments{
\item{obj}{A "HDP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{w}{numeric, sample weights.}

\item{...}{further arguments passed to the corresponding sufficientStatistics method of the "BasicBayesian" object.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure: \cr
Create an object of type "HDP", which represents the Dirichlet-Process model structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
     theta_k|psi ~ H0(psi) \cr
     x|theta_k,k ~ F(theta_k) \cr
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_k correspondingly. \cr
In the case of HDP, z and k can only be positive integers. \cr
The sufficient statistics of a set of samples x in a "HDP" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP", see examples.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{HDP}}, \code{\link{sufficientStatistics.HDP}}
}
