% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics_Weighted.HDP2}
\alias{sufficientStatistics_Weighted.HDP2}
\title{Weighted sufficient statistics of a "HDP2" object}
\usage{
\method{sufficientStatistics_Weighted}{HDP2}(obj, x, w, ...)
}
\arguments{
\item{obj}{A "HDP2" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{w}{numeric, sample weights.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure: \cr
Create an object of type "HDP2", which represents the model structure: \cr
     G_m |eta ~ DP(eta,U), m = 1:M \cr
     G_mj|gamma ~ DP(gamma,G_m), j = 1:J_m \cr
     pi_mj|G_mj,alpha ~ DP(alpha,G_mj) \cr
     z|pi_mj ~ Categorical(pi_mj) \cr
     k|z,G_mj ~ Categorical(G_mj), if z is a sample from the base measure G_mj \cr
     u|k,G_m ~ Categorical(G_m), if k is a sample from the base measure G_m \cr
     theta_u|psi ~ H0(psi) \cr
     x|theta_u,u ~ F(theta_u) \cr
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_m) is a Dirichlet Process on integers with concentration parameter gamma and base measure G_m. DP(alpha,G_mj) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_mj. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_u correspondingly. \cr
In the case of HDP2, u, z and k can only be positive integers. \cr
The sufficient statistics of a set of samples x in a "HDP2" object is the same sufficient statistics of the "BasicBayesian" inside the "HDP2", see examples.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{HDP2}}, \code{\link{sufficientStatistics.HDP2}}
}
